switch_menu:
; switch second/first menu layout
     mov        esi,menu_data
     mov        edi,menu_buffer
     cld
     xor        ebx,ebx
     cmp        [esi+9],dword 'morp'  ; morph in second menu
     jne        @f
     or         ebx,-1  ; mark
     xchg       esi,edi
   @@:
     mov        ecx,MENU_SIZE
     rep        movsb
     or         ebx,ebx
     jnz        .en
     mov        esi,menu_data2
     mov        edi,menu_data
     mov        ecx,5
   @@:  
     add        edi,9
     push       ecx
     mov        ecx,MENU_SIZE2
     rep        movsb
     pop        ecx
     loop       @b
  ;  add        edi,menu_data.op - menu_data
   .en:
ret
write_text:
;   eax - x * 65536 + y -> where to display
;   ebx - pointer to character table
;   ecx - size x * 65536 + size y -> size of screen buffer
;   esi - pointer to ASCIIZ string to display
;   edi - pointer to screen buffer
;   edx - char width
 .x            equ word   [ebp-2]
 .y            equ word   [ebp-4]
 .chr_tab_ptr  equ dword  [ebp-12]
 .xres_m       equ word   [ebp-6]
 .yres_m       equ word   [ebp-8]
 .ascii_string_ptr equ dword [ebp-16]
 .m_screen_ptr equ dword  [ebp-20]
 .fact_char    equ dword  [ebp-24]
 .CHAR_X       equ  8
 .CHAR_Y       equ  16
 .CHAR_LN_X    equ  128
 .CHAR_LN_Y    equ  256
      pushad
      mov    ebp, esp
      push   eax
      push   ecx
      cmp    [menu_data+7],word 20
      je     @f
      mov    edx,9
      mov    ebx,font_tab2 + 62     ; small font cause
    @@:
      push   ebx
      push   esi
      push   edi
      push   edx
      cld
   .decode:
      lodsb
      mov    ebx,eax
      not    eax
      and    eax,0x0000000f
      and    ebx,0x000000f0
      imul   ebx,.fact_char
      add    eax,ebx
      add    eax,.chr_tab_ptr   ; eax -> cur position in chr table

      movzx  ebx,.y
      movzx  ecx,.xres_m
      imul   ebx,ecx
      movzx  ecx,.x
      add    ebx,ecx
      shl    ebx,2
      add    ebx,.m_screen_ptr ; ebx - cur position on menu screen

      mov    ecx,.fact_char ; char width
    .loop1:
      push   ecx
      movzx  edx,byte[eax]
      xor    ecx,ecx
    .inner_loop:
      shr    edx,1
      jc     @f
      mov    [ebx+ecx],dword 0x00ffffff   ; col of written char
    @@:
      add    ecx,4
      cmp    ecx,32
      jnge   .inner_loop

      movzx  ecx,.xres_m
      shl    ecx,2
      add    ebx,ecx       ; .xres_m menu buffer width*4 in dwords
      add    eax,16        ; 16 chr_tab width  (in bytes)
      pop    ecx
      loop   .loop1
      add    .x,8         ; 8 points of the screen
      cmp    [esi],byte 0
      jne    .decode  ; next char ?
      mov    esp,ebp
      popad
ret
;====================================================================
write_frame:
    ; xm4  =  lo->hi width, color, buffer ptr
    ; eax  -  x2 shl 16 + x1
    ; ebx  -  y2 shl 16 + y1
    ; xmm6 -  min x, min y
    ; xmm7 -  max x, max y
     .ymn   equ  [ebp-4]
     .xmn   equ  [ebp-8]
     .ymx   equ  [ebp-12]
     .xmx   equ  [ebp-16]
     .max   equ  [ebp-20]
     .min   equ  [ebp-24]
     .dx    equ  [ebp-28]
     .dy    equ  [ebp-32]
     .ptr   equ  [ebp-36]
     .col   equ  [ebp-40]
     .width equ  [ebp-44]
     push      ebp
     mov       ebp,esp
     sub       esp,50
     movups    .width,xmm4
     xorps     xmm0,xmm0
     push      ebx eax
     movlps    xmm3,[esp]
     add       esp,8
     pshuflw   xmm3,xmm3,10001101b
     movaps    xmm2,xmm3
     shufps    xmm2,xmm2,11111101b
     movaps    xmm1,xmm3
     movaps    xmm4,xmm3
     movaps    xmm5,xmm3
     packssdw  xmm7,xmm7
     packssdw  xmm6,xmm6
     pcmpgtw   xmm4,xmm7
     pcmpgtw   xmm5,xmm6
     xorps     xmm4,xmm5
     pmovmskb  edx,xmm4
     and       edx,1111b
     cmp       edx,1111b
     jne       .end

     pmaxsw    xmm3,xmm2
     pminsw    xmm2,xmm1
     punpcklwd xmm3,xmm0
     punpcklwd xmm2,xmm0
     movlps    .xmn,xmm2
     movlps    .xmx,xmm3

     mov       ecx,.xmx
     sub       ecx,.xmn
     or        ecx,ecx
     jbe       .end
     mov       .dx,ecx
     cld
     mov       esi,.width
     mov       ebx,.ptr
     mov       eax,.ymn
     mul       esi
     add       eax,.xmn
     shl       eax,2
     xchg      edi,eax
     add       edi,ebx

     mov       eax,.col
     rep       stosd
     mov       ecx,.ymx
     sub       ecx,.ymn
     mov       .dy,ecx
     dec       esi
     shl       esi,2
     cld
   @@:
     stosd
     add       edi,esi
     loop      @b
     mov       ecx,.dx
     std
     rep       stosd
     mov       ecx,.dy
   @@:
     stosd
     sub       edi,esi
     loop      @b
     cld
  .end:
     mov       esp,ebp
     pop       ebp
ret
